<!-- templates/header.php -->

<?php
$base_url = '/adwenpasupermart/public';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>AdwenpaSuperMart</title>
    <link rel="stylesheet" href="<?php echo $base_url; ?>/assets/css/style.css" />
    <style>
        /* Basic reset */
        * {
            box-sizing: border-box;
        }
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }
        /* Header styling */
        header {
            background-color: #004080; /* dark blue*/
            color: white;
            padding: 10px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
        }
        .logo {
            font-size: 1.5rem;
            font-weight: bold;
            letter-spacing: 2px;
        }
        nav {
            display: flex;
            gap: 15px;
        }
        nav a {
            color: white;
            text-decoration: none;
            padding: 8px 12px;
            border-radius: 4px;
            transition: background-color 0.3s ease;
            font-weight: 600;
        }
        nav a:hover, nav a.active {
            background-color: #0066cc;
        }
        /* Hamburger menu for mobile */
        .menu-toggle {
            display: none;
            flex-direction: column;
            cursor: pointer;
            padding: 10px;
        }
        .menu-toggle span {
            height: 3px;
            width: 25px;
            background: white;
            margin-bottom: 4px;
            border-radius: 2px;
        }
        /* Responsive styles */
        @media (max-width: 768px) {
            nav {
                display: none;
                flex-direction: column;
                width: 100%;
                background-color: #004080;
                margin-top: 10px;
                padding: 10px 0;
            }
            nav.show {
                display: flex;
            }
            .menu-toggle {
                display: flex;
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const toggle = document.querySelector('.menu-toggle');
            const nav = document.querySelector('nav');
            toggle.addEventListener('click', () => {
                nav.classList.toggle('show');
            });
        });
    </script>
</head>
<body>
    <header>
        <div class="logo">AdwenpaSuperMart</div>
        <div class="menu-toggle" aria-label="Toggle menu" role="button" tabindex="0">
            <span></span>
            <span></span>
            <span></span>
        </div>
        <nav>
            <a href="<?php echo $base_url; ?>/dashboard.php" class="active">Dashboard</a>
            <a href="<?php echo $base_url; ?>/products.php">Products</a>
            <a href="<?php echo $base_url; ?>/sales.php">Sales</a>
            <a href="<?php echo $base_url; ?>/users.php">Users</a>
            <a href="<?php echo $base_url; ?>/settings.php">Settings</a>
            <a href="<?php echo $base_url; ?>/logout.php">Logout</a>
        </nav>
    </header>
