<?php
// src/Services/SaleService.php

require_once __DIR__ . '/../Models/Sale.php';

class SaleService {
    private $saleModel;

    public function __construct() {
        $this->saleModel = new Sale();
    }

    /**
     * Process creating a sale including all business rules 
     * and validations (expandable).
     *
     * @param array $saleData Associative array with sale details
     * @param array $items List of sale item arrays
     * @return int The new sale ID on success
     * @throws Exception on failure or validation error
     */
    public function createSale(array $saleData, array $items) {
        // Add business validations as needed
        if (empty($items)) {
            throw new Exception("Sale must contain at least one item.");
        }
        if ($saleData['total_amount'] <= 0) {
            throw new Exception("Total amount must be positive.");
        }

        // You could include discount validation here, stock checks, etc.

        // Delegate actual creation to the Sale model
        return $this->saleModel->createSale($saleData, $items);
    }

    /**
     * Retrieve all sales (can add filtering and paging)
     */
    public function listSales() {
        return $this->saleModel->getAllSales();
    }

    /**
     * Get a particular sale with items by ID
     */
    public function getSale(int $saleId) {
        $sale = $this->saleModel->getSaleById($saleId);
        if (!$sale) {
            throw new Exception("Sale not found");
        }
        return $sale;
    }
}
