<?php
namespace App\Models;

use App\Database\Database;
use PDO;

class Unit {
    private PDO $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    /**
     * Fetch all units from database
     * 
     * @return array Array of units with keys 'unit_id' and 'unit_name'
     */
    public function getAllUnits(): array {
        $stmt = $this->pdo->query("SELECT unit_id, unit_name FROM units ORDER BY unit_name");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // You can add more methods here for creating, updating, deleting units if needed
}
