<?php
namespace App\Models;

use App\Database\Database;

class Supplier {
    private $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    public function getAllSuppliers(): array {
        $stmt = $this->pdo->query("SELECT * FROM suppliers ORDER BY name ASC");
        return $stmt->fetchAll(\PDO::FETCH_ASSOC);
    }

    // Alias to getAllSuppliers for compatibility
    public function getAll(): array {
        return $this->getAllSuppliers();
    }

    public function getSupplierById(int $supplier_id): ?array {
        $stmt = $this->pdo->prepare("SELECT * FROM suppliers WHERE supplier_id = ?");
        $stmt->execute([$supplier_id]);
        return $stmt->fetch(\PDO::FETCH_ASSOC) ?: null;
    }

    public function addSupplier(string $name, string $contact_name, string $phone, string $email, string $address, string $payment_terms): bool {
        $sql = "INSERT INTO suppliers (name, contact_name, phone, email, address, payment_terms) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([$name, $contact_name, $phone, $email, $address, $payment_terms]);
    }

    public function updateSupplier(int $supplier_id, string $name, string $contact_name, string $phone, string $email, string $address, string $payment_terms): bool {
        $sql = "UPDATE suppliers SET name = ?, contact_name = ?, phone = ?, email = ?, address = ?, payment_terms = ? WHERE supplier_id = ?";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([$name, $contact_name, $phone, $email, $address, $payment_terms, $supplier_id]);
    }

    public function deleteSupplier(int $supplier_id): bool {
        $stmt = $this->pdo->prepare("DELETE FROM suppliers WHERE supplier_id = ?");
        return $stmt->execute([$supplier_id]);
    }
}
