<?php
namespace App\Models;

use App\Database\Database;

class Stock {
    private $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    public function getAllStockItems(): array {
        $stmt = $this->pdo->query("SELECT s.*, i.product_name, i.sku, b.branch_name, s.last_restocked FROM stock s LEFT JOIN inventory i ON s.product_id = i.inventory_id LEFT JOIN branches b ON s.branch_id = b.branch_id ORDER BY i.product_name ASC");
        return $stmt->fetchAll(\PDO::FETCH_ASSOC);
    }

    public function addStock($product_id, $quantity, $branch_id = null) {
        // Check if stock record exists for product+branch
        $stmt = $this->pdo->prepare("SELECT stock_id, quantity FROM stock WHERE product_id = ? AND (branch_id = ? OR (branch_id IS NULL AND ? IS NULL))");
        $stmt->execute([$product_id, $branch_id, $branch_id]);
        $existing = $stmt->fetch(\PDO::FETCH_ASSOC);

        if ($existing) {
            // Update quantity and last_restocked
            $newQuantity = (int)$existing['quantity'] + (int)$quantity;
            $update = $this->pdo->prepare("UPDATE stock SET quantity = ?, last_restocked = NOW() WHERE stock_id = ?");
            return $update->execute([$newQuantity, $existing['stock_id']]);
        } else {
            // Insert new stock record
            $insert = $this->pdo->prepare("INSERT INTO stock (product_id, quantity, branch_id, last_restocked) VALUES (?, ?, ?, NOW())");
            return $insert->execute([$product_id, $quantity, $branch_id]);
        }
    }

    public function getStockById(int $stock_id): ?array {
        $stmt = $this->pdo->prepare("SELECT * FROM stock WHERE stock_id = ?");
        $stmt->execute([$stock_id]);
        return $stmt->fetch(\PDO::FETCH_ASSOC) ?: null;
    }

    public function updateStock($stock_id, $product_id, $quantity, $branch_id = null) {
        $sql = "UPDATE stock SET product_id = ?, quantity = ?, branch_id = ?, last_restocked = NOW() WHERE stock_id = ?";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([$product_id, $quantity, $branch_id, $stock_id]);
    }

    public function deleteStock($stock_id) {
        $stmt = $this->pdo->prepare("DELETE FROM stock WHERE stock_id = ?");
        return $stmt->execute([$stock_id]);
    }
}
