<?php
namespace App\Models;

use App\Database\Database;

class Inventory {
    private $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    public function getAllItems(): array {
        $stmt = $this->pdo->query("SELECT i.*, b.branch_name FROM inventory i LEFT JOIN branches b ON i.branch_id = b.branch_id ORDER BY i.inventory_id DESC");
        return $stmt->fetchAll(\PDO::FETCH_ASSOC);
    }

    public function getItemById(int $inventory_id): ?array {
        $stmt = $this->pdo->prepare("SELECT * FROM inventory WHERE inventory_id = ?");
        $stmt->execute([$inventory_id]);
        return $stmt->fetch(\PDO::FETCH_ASSOC) ?: null;
    }

    public function createItem($product_name, $sku, $quantity, $purchase_price, $selling_price, $branch_id = null) {
        $sql = "INSERT INTO inventory (product_name, sku, quantity, purchase_price, selling_price, branch_id) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([$product_name, $sku, $quantity, $purchase_price, $selling_price, $branch_id]);
    }

    public function updateItem($inventory_id, $product_name, $sku, $quantity, $purchase_price, $selling_price, $branch_id = null) {
        $sql = "UPDATE inventory SET product_name = ?, sku = ?, quantity = ?, purchase_price = ?, selling_price = ?, branch_id = ? WHERE inventory_id = ?";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([$product_name, $sku, $quantity, $purchase_price, $selling_price, $branch_id, $inventory_id]);
    }

    public function deleteItem($inventory_id) {
        $stmt = $this->pdo->prepare("DELETE FROM inventory WHERE inventory_id = ?");
        return $stmt->execute([$inventory_id]);
    }
}
