<?php
namespace App\Models;

use App\Database\Database;
use PDO;

class Category {
    private PDO $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    /**
     * Fetch all categories from database
     * 
     * @return array Array of categories with keys 'category_id' and 'category_name'
     */
    public function getAllCategories(): array {
        $stmt = $this->pdo->query("SELECT category_id, category_name FROM categories ORDER BY category_name");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Additional CRUD methods can be added here as needed
}
