<?php
namespace App\Models;

use App\Database\Database;

class Branch {
    private $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    public function createBranch($branch_name, $address, $phone) {
        $sql = "INSERT INTO branches (branch_name, address, phone) VALUES (?, ?, ?)";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute([$branch_name, $address, $phone]);
    }

    public function getAllBranches(): array {
        $stmt = $this->pdo->query("SELECT * FROM branches ORDER BY branch_id DESC");
        return $stmt->fetchAll(\PDO::FETCH_ASSOC);
    }

    public function deleteBranch($branch_id) {
        $stmt = $this->pdo->prepare("DELETE FROM branches WHERE branch_id = ?");
        return $stmt->execute([$branch_id]);
    }

    public function countBranches(): int {
        $stmt = $this->pdo->query("SELECT COUNT(*) FROM branches");
        return (int) $stmt->fetchColumn();
    }
}
