<?php
namespace App\Models;

use App\Database\Database;
use PDO;

class AuditLog {
    private PDO $pdo;

    public function __construct() {
        $config = require __DIR__ . '/../../config/config.php';
        $dbConfig = $config['db'];
        $this->pdo = Database::getInstance($dbConfig)->getConnection();
    }

    // Public getter to access PDO connection safely
    public function getConnection(): PDO {
        return $this->pdo;
    }

    /**
     * Insert a log entry
     * @param int $userId - ID of user performing action
     * @param string $action - action name, e.g. 'create_sale'
     * @param string|null $details - JSON or text details
     * @return bool
     */
    public function log(int $userId, string $action, ?string $details = null): bool {
        $stmt = $this->pdo->prepare("INSERT INTO audit_logs (user_id, action, details) VALUES (:user_id, :action, :details)");
        return $stmt->execute([
            ':user_id' => $userId,
            ':action' => $action,
            ':details' => $details,
        ]);
    }

    /**
     * Retrieve recent logs (optional limits)
     * @param int $limit
     * @return array
     */
    public function getRecentLogs(int $limit = 100): array {
        $stmt = $this->pdo->prepare("SELECT al.*, u.username FROM audit_logs al JOIN users u ON al.user_id = u.user_id ORDER BY al.created_at DESC LIMIT ?");
        $stmt->bindValue(1, $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
