<?php
// src/Middleware/AuthMiddleware.php

class AuthMiddleware {
    public function handle(callable $next) {
        session_start();

        if (!isset($_SESSION['user']) || empty($_SESSION['user'])) {
            // User not authenticated - redirect or return unauthorized JSON
            if ($this->isApiRequest()) {
                http_response_code(401);
                echo json_encode(['error' => 'Unauthorized: Please login.']);
                exit;
            } else {
                header('Location: /login.php');
                exit;
            }
        }
        // User is authenticated, continue to next middleware/controller
        return $next();
    }

    private function isApiRequest() {
        // Simple check assuming API endpoints contain '/api/' in URL
        return strpos($_SERVER['REQUEST_URI'], '/api/') !== false;
    }
}
