<?php
// helpers.php or a common utilities file

use App\Models\AuditLog;

/**
 * Log an audit action with optional details and IP
 * @param int $userId User ID performing the action
 * @param string $action Action name e.g. 'create_sale', 'user_login'
 * @param string|null $details JSON string or message describing action
 * @param string|null $ipAddress IP address of user (auto-detected if omitted)
 * @return bool
 */
function log_audit_action(int $userId, string $action, ?string $details = null, ?string $ipAddress = null): bool {
    $auditLog = new AuditLog();
    $ip = $ipAddress ?? ($_SERVER['REMOTE_ADDR'] ?? 'unknown');
    return $auditLog->log($userId, $action, $details);
}
