<?php
// src/Helpers/AuthHelper.php

class AuthHelper {
    // Start session if not started
    public static function startSession() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    // Log user in by storing user info in session
    public static function loginUser(array $user) {
        self::startSession();
        // Store minimal user info except password hash
        $_SESSION['user'] = [
            'user_id' => $user['user_id'],
            'username' => $user['username'],
            'full_name' => $user['full_name'],
            'email' => $user['email'],
            'role' => $user['role'],
            'branch_id' => $user['branch_id'],
        ];
    }

    // Return currently logged-in user info or null
    public static function getCurrentUser() {
        self::startSession();
        return $_SESSION['user'] ?? null;
    }

    // Check if a user is logged in
    public static function isLoggedIn(): bool {
        self::startSession();
        return isset($_SESSION['user']);
    }

    // Logout the current user
    public static function logout() {
        self::startSession();
        $_SESSION = [];
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000,
                $params["path"], $params["domain"],
                $params["secure"], $params["httponly"]
            );
        }
        session_destroy();
    }

    // Check if the current user has a specific role
    public static function userHasRole(string $role): bool {
        $user = self::getCurrentUser();
        if (!$user) return false;
        return $user['role'] === $role;
    }
}
