<?php
namespace App\Database;

use PDO;
use PDOException;

class Database {
    private static ?Database $instance = null;
    private PDO $connection;

    private function __construct(array $dbConfig) {
        $dsn = "mysql:host={$dbConfig['host']};dbname={$dbConfig['name']};charset={$dbConfig['charset']}";
        try {
            $this->connection = new PDO($dsn, $dbConfig['user'], $dbConfig['pass']);
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Database connection error: " . $e->getMessage());
        }
    }

    public static function getInstance(array $dbConfig = []): self {
        if (self::$instance === null) {
            if (empty($dbConfig))
                throw new \Exception("DB config required on first call");
            self::$instance = new self($dbConfig);
        }
        return self::$instance;
    }

    public function getConnection(): PDO {
        return $this->connection;
    }
}
