<?php
// src/Controllers/SaleController.php

require_once __DIR__ . '/../Models/Sale.php';
require_once __DIR__ . '/../Middleware/AuthMiddleware.php';

class SaleController {
    private $saleModel;
    private $authMiddleware;

    public function __construct() {
        $this->saleModel = new Sale();
        $this->authMiddleware = new AuthMiddleware();
    }

    // Create a new sale order
    public function createSale() {
        $this->authMiddleware->handle(function() {
            header('Content-Type: application/json');

            // Only accept POST requests
            if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
                http_response_code(405);
                echo json_encode(['error' => 'Method Not Allowed']);
                exit;
            }

            $input = json_decode(file_get_contents('php://input'), true);

            if (!$input || !isset($input['saleData']) || !isset($input['items'])) {
                http_response_code(400);
                echo json_encode(['error' => 'Invalid request payload']);
                exit;
            }

            try {
                $saleId = $this->saleModel->createSale($input['saleData'], $input['items']);
                echo json_encode(['success' => true, 'sale_id' => $saleId]);
            } catch (Exception $e) {
                http_response_code(400);
                echo json_encode(['error' => $e->getMessage()]);
            }
        });
    }

    // Retrieve sales history (optionally filter by date or branch)
    public function listSales() {
        $this->authMiddleware->handle(function() {
            header('Content-Type: application/json');

            // Example: retrieve sales list (for simplicity, get all)
            $sales = $this->saleModel->getAllSales();  // You'd implement this in Sale model
            echo json_encode(['sales' => $sales]);
        });
    }
}
