<?php
namespace App\Controllers;

use App\Models\User;

class AuthController {
    private $userModel;

    public function __construct() {
        $this->userModel = new User();
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    /**
     * Authenticate user by username and password.
     * Returns user array on success or error string on failure.
     */
    public function login(string $username, string $password) {
        if (empty($username) || empty($password)) {
            return "Username and password required";
        }

        $user = $this->userModel->authenticate($username, $password);

        if ($user) {
            // Set session user info
            $_SESSION['user'] = [
                'user_id' => $user['user_id'],
                'username' => $user['username'],
                'full_name' => $user['full_name'],
                'email' => $user['email'],
                'role' => $user['role'],
                'branch_id' => $user['branch_id']
            ];
            return $user;
        } else {
            return "Invalid username or password";
        }
    }

    public function logout(): void {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        $_SESSION = [];
        session_destroy();
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'Logged out']);
        exit;
    }

    public function check(): void {
        header('Content-Type: application/json');
        if (isset($_SESSION['user'])) {
            echo json_encode(['logged_in' => true, 'user' => $_SESSION['user']]);
        } else {
            echo json_encode(['logged_in' => false]);
        }
    }
}
