<?php
// units.php - Insert default unit measures for sales and POS

require_once __DIR__ . '/../bootstrap.php';
require_once __DIR__ . '/../vendor/autoload.php';

use App\Database\Database;

try {
    $config = require __DIR__ . '/../config/config.php';
    $dbConfig = $config['db'];

    $db = Database::getInstance($dbConfig)->getConnection();

    // Units to insert
    $units = [
        'box',
        'tin',
        'sachet',
        'bag',
        'cup',
        'pack',
        // Add more units here
    ];

    $stmt = $db->prepare("INSERT INTO units (unit_name) VALUES (:unit_name)");

    foreach ($units as $unit) {
        // Avoid duplicates by checking first (optional)
        $checkStmt = $db->prepare("SELECT COUNT(*) FROM units WHERE unit_name = :unit_name");
        $checkStmt->execute([':unit_name' => $unit]);
        if ($checkStmt->fetchColumn() == 0) {
            $stmt->execute([':unit_name' => $unit]);
        }
    }

    echo "Units inserted or already exist.";

} catch (Exception $e) {
    echo "Error inserting units: " . $e->getMessage();
}
