<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Supplier;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$supplierModel = new Supplier();
$suppliers = $supplierModel->getAllSuppliers();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Suppliers - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
    <h1>Suppliers</h1>
    <a href="add_supplier.php" class="btn btn-primary mb-3">Add New Supplier</a>

    <table class="table table-striped table-bordered">
        <thead class="table-dark">
            <tr>
                <th>Name</th>
                <th>Contact Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Address</th>
                <th>Payment Terms</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($suppliers)): ?>
            <tr>
                <td colspan="7" class="text-center">No suppliers found.</td>
            </tr>
            <?php else: ?>
            <?php foreach ($suppliers as $supplier): ?>
            <tr>
                <td><?= htmlspecialchars($supplier['name']) ?></td>
                <td><?= htmlspecialchars($supplier['contact_name']) ?></td>
                <td><?= htmlspecialchars($supplier['phone']) ?></td>
                <td><?= htmlspecialchars($supplier['email']) ?></td>
                <td><?= htmlspecialchars($supplier['address']) ?></td>
                <td><?= htmlspecialchars($supplier['payment_terms']) ?></td>
                <td>
                    <a href="edit_supplier.php?id=<?= $supplier['supplier_id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                    <a href="delete_supplier.php?id=<?= $supplier['supplier_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure to delete this supplier?')">Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
