<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\StockMovement;
use App\Models\Inventory;
use App\Models\Branch;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$stockMovementModel = new StockMovement();
$inventoryModel = new Inventory();
$branchModel = new Branch();

$products = $inventoryModel->getAllItems();
$branches = $branchModel->getAllBranches();

// Read filters from GET
$filter_product = $_GET['product_id'] ?? '';
$filter_branch = $_GET['branch_id'] ?? '';
$filter_movement_type = $_GET['movement_type'] ?? '';
$filter_date_from = $_GET['date_from'] ?? '';
$filter_date_to = $_GET['date_to'] ?? '';

// Use model method to get filtered movements
$filters = [
    'product_id' => $filter_product,
    'branch_id' => $filter_branch,
    'movement_type' => $filter_movement_type,
    'date_from' => $filter_date_from,
    'date_to' => $filter_date_to,
];
$movements = $stockMovementModel->getFilteredMovements($filters);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Stock Movements with Filters - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">

    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
    <h1>Stock Movements</h1>

    <form method="get" class="row g-3 mb-3">
        <div class="col-md-3">
            <label for="product_id" class="form-label">Product</label>
            <select name="product_id" id="product_id" class="form-select">
                <option value="">All Products</option>
                <?php foreach ($products as $p): ?>
                    <option value="<?= $p['inventory_id'] ?>" <?= ($filter_product == $p['inventory_id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($p['product_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label for="branch_id" class="form-label">Branch</label>
            <select name="branch_id" id="branch_id" class="form-select">
                <option value="">All Branches</option>
                <?php foreach ($branches as $b): ?>
                    <option value="<?= $b['branch_id'] ?>" <?= ($filter_branch == $b['branch_id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($b['branch_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <label for="movement_type" class="form-label">Movement Type</label>
            <select name="movement_type" id="movement_type" class="form-select">
                <option value="">All</option>
                <option value="in" <?= ($filter_movement_type == 'in') ? 'selected' : '' ?>>In</option>
                <option value="out" <?= ($filter_movement_type == 'out') ? 'selected' : '' ?>>Out</option>
                <option value="adjustment" <?= ($filter_movement_type == 'adjustment') ? 'selected' : '' ?>>Adjustment</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="date_from" class="form-label">From Date</label>
            <input type="date" id="date_from" name="date_from" class="form-control" value="<?= htmlspecialchars($filter_date_from) ?>">
        </div>
        <div class="col-md-2">
            <label for="date_to" class="form-label">To Date</label>
            <input type="date" id="date_to" name="date_to" class="form-control" value="<?= htmlspecialchars($filter_date_to) ?>">
        </div>

        <div class="col-md-12">
            <button type="submit" class="btn btn-primary">Filter</button>
            <a href="stock_movements.php" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-striped table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Product</th>
                    <th>SKU</th>
                    <th>Branch</th>
                    <th>Quantity</th>
                    <th>Movement Type</th>
                    <th>Reference</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($movements)): ?>
                    <tr>
                        <td colspan="9" class="text-center">No stock movements found.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($movements as $m): ?>
                    <tr>
                        <td><?= htmlspecialchars($m['stock_movement_id']) ?></td>
                        <td><?= htmlspecialchars($m['product_name'] ?? 'N/A') ?></td>
                        <td><?= htmlspecialchars($m['sku'] ?? '') ?></td>
                        <td><?= htmlspecialchars($m['branch_name'] ?? 'N/A') ?></td>
                        <td><?= (int)$m['quantity'] ?></td>
                        <td><?= htmlspecialchars($m['movement_type']) ?></td>
                        <td><?= htmlspecialchars($m['reference'] ?? '') ?></td>
                        <td><?= htmlspecialchars($m['created_at']) ?></td>
                        <td>
                            <a href="edit_stock_movement.php?id=<?= $m['stock_movement_id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="delete_stock_movement.php?id=<?= $m['stock_movement_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure to delete this movement?')">Delete</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
