<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\StockMovement;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$stockMovementModel = new StockMovement();
$currentStock = $stockMovementModel->getCurrentStock();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Stock Overview - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
    <h1>Stock Overview</h1>
    <a href="stock_movements.php" class="btn btn-primary mb-3">Manage Stock Movements</a>
    <div class="table-responsive">
        <table class="table table-striped table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>Product</th>
                    <th>SKU</th>
                    <th>Branch</th>
                    <th>Current Quantity</th>
                </tr>
            </thead>
            <tbody>
                <?php if(empty($currentStock)): ?>
                <tr><td colspan="4" class="text-center">No stock records found.</td></tr>
                <?php else: ?>
                <?php foreach($currentStock as $stock): ?>
                <tr>
                    <td><?= htmlspecialchars($stock['product_name'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($stock['sku'] ?? '') ?></td>
                    <td><?= htmlspecialchars($stock['branch_name'] ?? 'N/A') ?></td>
                    <td><?= (int)$stock['current_quantity'] ?></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
