<?php
require_once __DIR__ . '/../bootstrap.php';

use App\Models\User;

session_start();

$userModel = new User();

// Check if any user exists
$existingUsers = $userModel->countUsers();

if ($existingUsers > 0) {
    // Require admin login for further registrations
    if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
        header('Location: login.php');
        exit;
    }
}

$errors = [];
$success = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $role = $_POST['role'] ?? 'user';
    $branch_id = empty($_POST['branch_id']) ? null : $_POST['branch_id']; // <-- Fix here

    if (!$username || !$password || !$email || !$role) {
        $errors[] = "Username, Password, Email and Role are required.";
    }

    if (empty($errors)) {
        $created = $userModel->createUser($username, $password, $full_name, $email, $role, $branch_id);
        if ($created) {
            $success = "User registered successfully.";
        } else {
            $errors[] = "Failed to register user.";
        }
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Setup Admin - Register New User</title>
<style>
body {
    font-family: Arial, sans-serif;
    background: #f4f7f8;
    margin: 0; padding: 0;
}
.container {
    max-width: 480px;
    margin: 50px auto;
    padding: 30px;
    background: white;
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
}
h1 {
    text-align: center;
    color: #333;
}
form label {
    display: block;
    margin-bottom: 8px;
    margin-top: 15px;
    color: #555;
    font-weight: bold;
}
form input[type="text"],
form input[type="email"],
form input[type="password"],
form select {
    width: 100%;
    padding: 10px;
    font-size: 1rem;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-sizing: border-box;
    transition: border-color 0.3s ease;
}
form input[type="text"]:focus,
form input[type="email"]:focus,
form input[type="password"]:focus,
form select:focus {
    border-color: #007bff;
    outline: none;
}
button {
    display: block;
    width: 100%;
    margin-top: 25px;
    padding: 12px;
    font-size: 1.1rem;
    font-weight: bold;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.25s ease;
}
button:hover {
    background-color: #0056b3;
}
.notice {
    margin-top: 20px;
    padding: 12px;
    border-radius: 4px;
}
.success {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}
.error {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}
</style>
</head>
<body>

<div class="container">
    <h1>Register New User</h1>

   if ($created) {
    // Redirect to login.php after successful registration
    header('Location: login.php');
    exit;
} else {
    $errors[] = "Failed to register user.";
}

    <?php if ($errors): ?>
        <div class="notice error">
            <ul>
                <?php foreach ($errors as $error): ?>
                    <li><?= htmlspecialchars($error) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <label for="username">Username</label>
        <input type="text" id="username" name="username" required />

        <label for="password">Password</label>
        <input type="password" id="password" name="password" required />

        <label for="full_name">Full Name</label>
        <input type="text" id="full_name" name="full_name" />

        <label for="email">Email</label>
        <input type="email" id="email" name="email" required />

        <label for="role">Role</label>
        <select id="role" name="role" required>
            <option value="user">User</option>
            <option value="admin">Admin</option>
        </select>

        <label for="branch_id">Branch ID (optional)</label>
        <input type="text" id="branch_id" name="branch_id" />

        <button type="submit">Register User</button>
    </form>
</div>

</body>
</html>
