<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// For demo - static or fetched from DB
$totalSalesToday = 1580.75;
$totalTransactionsToday = 34;
$averageSaleValue = 46.49;
$topProducts = [
    ['name' => 'Product A', 'units_sold' => 15],
    ['name' => 'Product B', 'units_sold' => 12],
    ['name' => 'Product C', 'units_sold' => 8]
];

$latestTransactions = [
    ['id' => 101, 'customer' => 'John Doe', 'amount' => 120.50, 'date' => '2025-10-27 10:45'],
    ['id' => 102, 'customer' => 'Jane Smith', 'amount' => 85.00, 'date' => '2025-10-27 11:10'],
    ['id' => 103, 'customer' => 'Sam Wilson', 'amount' => 65.25, 'date' => '2025-10-27 11:30'],
];

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Sales Overview - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            background-color: #f4f6f9;
        }
        .sidebar {
            width: 220px;
            height: 100vh;
            position: fixed;
            background-color: #343a40;
            padding-top: 1rem;
        }
        .sidebar a {
            color: white;
            padding: 1rem 1.5rem;
            display: block;
            text-decoration: none;
            font-weight: 600;
        }
        .sidebar a:hover, .sidebar a.active {
            background-color: #495057;
            color: #ffc107;
        }
        .main-content {
            margin-left: 220px;
            padding: 2rem;
        }
        h2 {
            margin-bottom: 1rem;
        }
        .card h5 {
            font-weight: 600;
        }
        .stats-icon {
            font-size: 2.5rem;
            opacity: 0.2;
            position: absolute;
            top: 15px;
            right: 20px;
        }
    </style>
</head>
<body>

<nav class="sidebar">
    <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
    <a href="users.php"><i class="bi bi-people-fill me-2"></i> Manage Users</a>
    <a href="branches.php"><i class="bi bi-building me-2"></i> Manage Branches</a>
    <a href="inventory.php"><i class="bi bi-box-seam me-2"></i> Inventory</a>
    <a href="sales_overview.php" class="active"><i class="bi bi-bar-chart-line-fill me-2"></i> Sales Overview</a>
    <a href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a>
</nav>

<div class="main-content">
    <h1>Sales Overview</h1>

    <div class="row g-4 my-3">
        <div class="col-md-4">
            <div class="card bg-primary text-white position-relative h-100">
                <div class="card-body">
                    <h5>Total Sales Today</h5>
                    <h2>$<?= number_format($totalSalesToday, 2) ?></h2>
                    <i class="bi bi-cash-stack stats-icon"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-success text-white position-relative h-100">
                <div class="card-body">
                    <h5>Transactions Today</h5>
                    <h2><?= $totalTransactionsToday ?></h2>
                    <i class="bi bi-bag-check stats-icon"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card bg-warning text-dark position-relative h-100">
                <div class="card-body">
                    <h5>Average Sale Value</h5>
                    <h2>$<?= number_format($averageSaleValue, 2) ?></h2>
                    <i class="bi bi-calculator stats-icon"></i>
                </div>
            </div>
        </div>
    </div>

    <h2>Top Selling Products</h2>
    <ul class="list-group mb-4" style="max-width: 400px;">
        <?php foreach ($topProducts as $product): ?>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <?= htmlspecialchars($product['name']) ?>
                <span class="badge bg-primary rounded-pill"><?= $product['units_sold'] ?></span>
            </li>
        <?php endforeach; ?>
    </ul>

    <h2>Latest Transactions</h2>
    <div class="table-responsive" style="max-width:800px;">
        <table class="table table-striped table-bordered">
            <thead class="table-secondary">
                <tr>
                    <th>Transaction ID</th>
                    <th>Customer</th>
                    <th>Amount</th>
                    <th>Date & Time</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($latestTransactions as $txn): ?>
                <tr>
                    <td><?= htmlspecialchars($txn['id']) ?></td>
                    <td><?= htmlspecialchars($txn['customer']) ?></td>
                    <td>$<?= number_format($txn['amount'], 2) ?></td>
                    <td><?= htmlspecialchars($txn['date']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <h2>Sales Chart</h2>
    <canvas id="salesChart" style="max-width: 700px; height: 300px;"></canvas>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Simulated sales data for chart
const labels = ['2025-10-21', '2025-10-22', '2025-10-23', '2025-10-24', '2025-10-25', '2025-10-26', '2025-10-27'];
const data = [1200, 1350, 1100, 1450, 1600, 1550, 1580];

const ctx = document.getElementById('salesChart').getContext('2d');
const salesChart = new Chart(ctx, {
    type: 'line',
    data: {
        labels: labels,
        datasets: [{
            label: 'Sales Last 7 Days',
            data: data,
            fill: true,
            borderColor: 'rgba(54, 162, 235, 1)',
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            tension: 0.3
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
