<?php include __DIR__ . '/../templates/header.php'; ?>

<main style="padding:20px; max-width: 1000px; margin: auto;">
    <h1>Sales</h1>
    <table style="width:100%; border-collapse: collapse;">
        <thead style="background-color: #004080; color: white;">
            <tr>
                <th style="padding: 10px; border:1px solid #ddd;">Sale ID</th>
                <th style="padding: 10px; border:1px solid #ddd;">Total Amount</th>
                <th style="padding: 10px; border:1px solid #ddd;">Payment Method</th>
                <th style="padding: 10px; border:1px solid #ddd;">Sales Rep</th>
                <th style="padding: 10px; border:1px solid #ddd;">Date</th>
            </tr>
        </thead>
        <tbody id="sales-list"></tbody>
    </table>
</main>

<script>
async function fetchSales() {
    try {
        const res = await fetch('/api/sale.php');
        const data = await res.json();
        const tbody = document.getElementById('sales-list');
        tbody.innerHTML = '';
        data.sales.forEach(sale => {
            const tr = document.createElement('tr');
            tr.innerHTML = `
                <td style="padding: 8px; border:1px solid #ddd;">${sale.sale_id}</td>
                <td style="padding: 8px; border:1px solid #ddd;">GHS ${sale.total_amount}</td>
                <td style="padding: 8px; border:1px solid #ddd;">${sale.payment_method}</td>
                <td style="padding: 8px; border:1px solid #ddd;">${sale.sales_rep_id}</td>
                <td style="padding: 8px; border:1px solid #ddd;">${new Date(sale.created_at).toLocaleString()}</td>
            `;
            tbody.appendChild(tr);
        });
    } catch (error) {
        console.error('Error loading sales:', error);
    }
}

fetchSales();
</script>

<?php include __DIR__ . '/../templates/footer.php'; ?>
