<?php
session_start();

require_once __DIR__ . '/../bootstrap.php';

use App\Models\Sale;

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['sale_id']) || !is_numeric($_GET['sale_id'])) {
    echo "Invalid or missing sale ID.";
    exit;
}

$saleId = (int)$_GET['sale_id'];

$saleModel = new Sale();

$sale = $saleModel->getSaleById($saleId);

if (!$sale) {
    echo "Sale not found.";
    exit;
}

$user = $_SESSION['user'];

// Optionally, verify if the sale belongs to the logged-in user (sales rep)
if ($sale['sales_rep_id'] !== $user['user_id']) {
    echo "You do not have permission to view this sale.";
    exit;
}

function esc($str) {
    return htmlspecialchars($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Sale Details #<?= esc($saleId) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
    <a class="navbar-brand" href="dashboard.php">Adwenpa POS</a>
    <ul class="navbar-nav ms-auto">
        <li class="nav-item"><span class="nav-link text-white">Hello, <?= esc($user['username']) ?></span></li>
        <li class="nav-item"><a href="logout.php" class="nav-link">Logout</a></li>
    </ul>
</nav>

<div class="container mt-4">
    <h1>Sale Details - ID #<?= esc($saleId) ?></h1>

    <dl class="row">
        <dt class="col-sm-3">Total Amount</dt>
        <dd class="col-sm-9"><?= esc(number_format($sale['total_amount'], 2)) ?></dd>

        <dt class="col-sm-3">Payment Method</dt>
        <dd class="col-sm-9"><?= esc($sale['payment_method']) ?></dd>

        <dt class="col-sm-3">Sale Date</dt>
        <dd class="col-sm-9"><?= esc($sale['sale_date']) ?></dd>

        <dt class="col-sm-3">Discount</dt>
        <dd class="col-sm-9"><?= esc(number_format($sale['discount'], 2)) ?></dd>

        <dt class="col-sm-3">Tax</dt>
        <dd class="col-sm-9"><?= esc(number_format($sale['tax'], 2)) ?></dd>

        <dt class="col-sm-3">Branch ID</dt>
        <dd class="col-sm-9"><?= esc($sale['branch_id']) ?></dd>
    </dl>

    <h2>Items</h2>

    <?php if (empty($sale['items'])): ?>
        <p>No items found for this sale.</p>
    <?php else: ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Quantity</th>
                    <th>Unit</th>
                    <th>Unit Price</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sale['items'] as $item): ?>
                    <tr>
                        <td><?= esc($item['product_name']) ?></td>
                        <td><?= esc($item['quantity']) ?></td>
                        <td><?= esc($item['unit'] ?? '') ?></td>
                        <td><?= esc(number_format($item['unit_price'], 2)) ?></td>
                        <td><?= esc(number_format($item['quantity'] * $item['unit_price'], 2)) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <a href="my_sales.php" class="btn btn-secondary">Back to My Sales</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
