<?php
session_start();

// Include Composer autoloader
require_once __DIR__ . '/../vendor/autoload.php';

use App\Models\Product;

// Ensure user is logged in and is admin
if (empty($_SESSION['user']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: login.php");
    exit;
}

// Optional: Regenerate session ID periodically to prevent session fixation
// session_regenerate_id(true);

$productModel = new Product();
$products = $productModel->getAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Products - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
    <h1>Products</h1>
    <a href="add_product.php" class="btn btn-primary mb-3">Add New Product</a>

    <table class="table table-striped table-bordered">
        <thead class="table-dark">
            <tr>
                <th>Product Name</th>
                <th>Unit</th>
                <th>Wholesale Price</th>
                <th>Retail Price</th>
                <th>Stock Qty</th>
                <th>Category</th>
                <th>Branch</th>
                <th>Is Pharma</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($products)): ?>
                <tr><td colspan="9" class="text-center">No products found.</td></tr>
            <?php else: ?>
                <?php foreach ($products as $product): ?>
                <tr>
                    <td><?= htmlspecialchars($product['product_name']) ?></td>
                    <td><?= htmlspecialchars($product['unit_name'] ?? '') ?></td>
                    <td><?= number_format($product['wholesale_price'], 2) ?></td>
                    <td><?= number_format($product['retail_price'], 2) ?></td>
                    <td><?= (int)$product['stock_quantity'] ?></td>
                    <td><?= htmlspecialchars($product['category_name'] ?? '') ?></td>
                    <td><?= htmlspecialchars($product['branch_name'] ?? '') ?></td>
                    <td><?= $product['is_pharma'] ? 'Yes' : 'No' ?></td>
                    <td>
                        <a href="edit_product.php?id=<?= (int)$product['product_id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="delete_product.php?id=<?= (int)$product['product_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure to delete this product?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
