<?php
session_start();

require_once __DIR__ . '/../bootstrap.php';
require_once __DIR__ . '/../vendor/autoload.php';

use App\Models\Sale;

// Only POST allowed
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Check user login
if (!isset($_SESSION['user'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$user = $_SESSION['user'];
$saleModel = new Sale();

// Retrieve and validate input
$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON input']);
    exit;
}

$saleData = $input['saleData'] ?? null;
$items = $input['items'] ?? null;

if (!$saleData || !$items || !is_array($items)) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing sale data or items']);
    exit;
}

// Repair saleData fields to ensure sales_rep_id and branch_id use session info where appropriate
$role = $user['role'] ?? '';

if ($role === 'sales_rep' || $role === 'cashier') {
    $saleData['sales_rep_id'] = $user['user_id'];
} elseif ($role === 'admin' && empty($saleData['sales_rep_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'sales_rep_id required for admin']);
    exit;
}

// Branch id fallback for role
if (empty($saleData['branch_id']) && !empty($user['branch_id'])) {
    $saleData['branch_id'] = $user['branch_id'];
}

try {
    $saleId = $saleModel->createSale($saleData, $items);
    echo json_encode(['success' => true, 'sale_id' => $saleId]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
