// public/js/pos.bundle.js

const micButton = document.getElementById('micButton');
const productSearchInput = document.getElementById('productSearch');
const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;

if (!SpeechRecognition) {
    micButton.disabled = true;
    micButton.title = "Speech Recognition not supported by your browser";
} else {
    // same code here...
    // all your existing JS code, functions, IndexedDB setup and handlers
}

function filterProducts() {
    // ...
}

let cart = [];
// IndexedDB setup and related functions: saveSaleOffline, loadOfflineSales etc.

// event handlers, addToCart, removeFromCart, updateQuantity,
// renderCart, updateTotal, processSale, renderReceipt...

window.addEventListener('online', syncOfflineSales);

// Initial load
renderCart();

// Save sale data to localStorage if offline
function saveSalesOffline(saleData) {
  let offlineSales = JSON.parse(localStorage.getItem('offlineSales') || '[]');
  offlineSales.push(saleData);
  localStorage.setItem('offlineSales', JSON.stringify(offlineSales));
}

// Sync locally saved sales when back online
async function syncOfflineSales() {
  if (!navigator.onLine) return; // Only sync if online

  let offlineSales = JSON.parse(localStorage.getItem('offlineSales') || '[]');

  for (const sale of offlineSales) {
    try {
      await fetch('/api/sales', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(sale)
      });
    } catch (err) {
      console.error('Failed to sync sale:', sale);
      return; // Stop syncing on failure to retry later
    }
  }

  localStorage.removeItem('offlineSales'); // Clear synced items
}

// Register event to sync when connection comes back
window.addEventListener('online', syncOfflineSales);
