<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// your existing code follows...

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Inventory;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$inventoryModel = new Inventory();
$items = $inventoryModel->getAllItems();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Inventory Management - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
    <h1>Inventory List</h1>
    <a href="add_inventory.php" class="btn btn-primary mb-3">Add New Item</a>

    <table class="table table-striped table-bordered">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Product Name</th>
                <th>SKU/Barcode</th>
                <th>Quantity</th>
                <th>Purchase Price</th>
                <th>Selling Price</th>
                <th>Branch</th>
                <th>Last Updated</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($items) === 0): ?>
            <tr><td colspan="9" class="text-center">No inventory items found.</td></tr>
            <?php else: ?>
                <?php foreach ($items as $item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['inventory_id']) ?></td>
                    <td><?= htmlspecialchars($item['product_name']) ?></td>
                    <td><?= htmlspecialchars($item['sku']) ?></td>
                    <td><?= htmlspecialchars($item['quantity']) ?></td>
                    <td>$<?= number_format($item['purchase_price'], 2) ?></td>
                    <td>$<?= number_format($item['selling_price'], 2) ?></td>
                    <td><?= htmlspecialchars($item['branch_name'] ?? 'N/A') ?></td>
                    <td><?= htmlspecialchars($item['updated_at'] ?? $item['created_at']) ?></td>
                    <td>
                        <a href="edit_inventory.php?id=<?= $item['inventory_id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="delete_inventory.php?id=<?= $item['inventory_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this item?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
