<?php
// index.php

session_start();
if (isset($_SESSION['username'])) {
    // Redirect logged in users to dashboard
    header('Location: dashboard.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Welcome to Adwenpa Supermart</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        html, body {
            height: 100%;
        }
        body {
            background: #0d6efd;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
        }
        .container {
            max-width: 480px;
            background: rgba(255, 255, 255, 0.1);
            padding: 3rem 2rem;
            border-radius: 12px;
            text-align: center;
            backdrop-filter: blur(20px);
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.3);
        }
        h1 {
            font-weight: 700;
            margin-bottom: 1rem;
        }
        p.lead {
            font-size: 1.25rem;
            margin-bottom: 2rem;
        }
        .btn-primary {
            font-size: 1.1rem;
            padding: 0.75rem 2rem;
            border-radius: 50px;
            font-weight: 600;
            box-shadow: 0 10px 25px rgb(0 123 255 / 0.5);
            transition: background-color 0.3s ease;
        }
        .btn-primary:hover {
            background-color: #084298;
        }
        footer {
            margin-top: 3rem;
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.7);
        }
        @media (max-width: 576px) {
            .container {
                padding: 2rem 1.5rem;
                max-width: 90%;
            }
            h1 {
                font-size: 1.75rem;
            }
        }
    </style>
</head>

<body>

    <div class="container">
        <h1>Welcome to Adwenpa Supermart</h1>
        <p class="lead">Manage your store’s sales, inventory, customers, and reports with ease.</p>
        <a href="login.php" class="btn btn-primary" role="button">Login to Start</a>
    </div>

    <footer>
        Designed by Adwenpa Consults (0543971188)
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
