<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\User;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$userModel = new User();
$errors = [];
$success = '';
$user = null;

// Get user ID to edit
$user_id = $_GET['id'] ?? null;
if (!$user_id || !is_numeric($user_id)) {
    die("Invalid user ID.");
}

// Fetch user data
$user = $userModel->getUserById((int)$user_id);
if (!$user) {
    die("User not found.");
}

// Handle update POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $role = $_POST['role'];
    $branch_id = empty($_POST['branch_id']) ? null : $_POST['branch_id'];

    if (!$username || !$email || !$role) {
        $errors[] = "Username, Email and Role are required.";
    }

    if (empty($errors)) {
        $updated = $userModel->updateUser((int)$user_id, $username, $full_name, $email, $role, $branch_id);
        if ($updated) {
            $success = "User updated successfully.";
            // Refresh user data
            $user = $userModel->getUserById((int)$user_id);
        } else {
            $errors[] = "Failed to update user.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Edit User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <h1>Edit User</h1>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <?php if ($errors): ?>
        <div class="alert alert-danger">
            <ul>
            <?php foreach ($errors as $e): ?>
                <li><?= htmlspecialchars($e) ?></li>
            <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="post" action="">
        <div class="mb-3">
            <label>Username:</label>
            <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" required>
        </div>
        <div class="mb-3">
            <label>Full Name:</label>
            <input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($user['full_name']) ?>">
        </div>
        <div class="mb-3">
            <label>Email:</label>
            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" required>
        </div>
        <div class="mb-3">
            <label>Role:</label>
            <select name="role" class="form-select" required>
                <option value="admin" <?= $user['role'] === 'admin' ? 'selected' : '' ?>>Admin</option>
                <option value="sales_rep" <?= $user['role'] === 'sales_rep' ? 'selected' : '' ?>>Sales Rep</option>
                <option value="cashier" <?= $user['role'] === 'cashier' ? 'selected' : '' ?>>Cashier</option>
                <option value="user" <?= $user['role'] === 'user' ? 'selected' : '' ?>>User</option>
            </select>
        </div>
        <div class="mb-3">
            <label>Branch ID (optional):</label>
            <input type="text" name="branch_id" class="form-control" value="<?= htmlspecialchars($user['branch_id']) ?>">
        </div>

        <button type="submit" class="btn btn-primary">Update User</button>
        <a href="users.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
