<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\User;

// Only admin allowed
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid user ID.");
}

$user_id = (int)$_GET['id'];
$userModel = new User();

// Optional: prevent admin from deleting themselves
if ($user_id === $_SESSION['user']['user_id']) {
    die("You cannot delete your own user account.");
}

$deleted = $userModel->deleteUser($user_id);

if ($deleted) {
    header("Location: users.php?msg=User+deleted+successfully");
    exit;
} else {
    die("Failed to delete user.");
}
