<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Supplier;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$supplier_id = $_GET['id'] ?? null;
if (!$supplier_id || !is_numeric($supplier_id)) {
    die("Invalid supplier ID.");
}

$supplierModel = new Supplier();
$deleted = $supplierModel->deleteSupplier((int)$supplier_id);

if ($deleted) {
    header("Location: suppliers.php?msg=Supplier+deleted+successfully");
    exit;
} else {
    die("Failed to delete supplier.");
}
