<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\StockMovement;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$movement_id = $_GET['id'] ?? null;
if (!$movement_id || !is_numeric($movement_id)) {
    die("Invalid movement ID.");
}

$stockMovementModel = new StockMovement();
$deleted = $stockMovementModel->deleteMovement((int)$movement_id);

if ($deleted) {
    header("Location: stock_movements.php?msg=Movement+deleted+successfully");
    exit;
} else {
    die("Failed to delete stock movement.");
}
