<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Stock;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid Stock ID.");
}

$stock_id = (int)$_GET['id'];
$stockModel = new Stock();

$deleted = $stockModel->deleteStock($stock_id);

if ($deleted) {
    header("Location: stock.php?msg=Stock+deleted+successfully");
    exit;
} else {
    die("Failed to delete stock item.");
}
