<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';
require_once __DIR__ . '/../vendor/autoload.php';

use App\Models\Product;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$product_id = $_GET['id'] ?? null;
if (!$product_id || !is_numeric($product_id)) {
    die("Invalid product ID.");
}

$productModel = new Product();
$deleted = $productModel->delete((int)$product_id);

if ($deleted) {
    header("Location: products.php?msg=Product+deleted+successfully");
    exit;
} else {
    die("Failed to delete product.");
}
