<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Inventory;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid inventory ID.");
}

$inventory_id = (int)$_GET['id'];
$inventoryModel = new Inventory();

$deleted = $inventoryModel->deleteItem($inventory_id);

if ($deleted) {
    // Optionally, add a success message via session or query string
    header("Location: inventory.php?msg=Inventory+item+deleted+successfully");
    exit;
} else {
    die("Failed to delete inventory item.");
}
