<?php
// categories.php - Insert initial product categories into database

require_once __DIR__ . '/../bootstrap.php';
require_once __DIR__ . '/../vendor/autoload.php';

use App\Database\Database;

try {
    // Load DB config
    $config = require __DIR__ . '/../config/config.php';
    $dbConfig = $config['db'];

    $db = Database::getInstance($dbConfig)->getConnection();

    // Categories to insert
    $categories = [
        'Soft drinks',
        'Toiletries',
        'Dairy',
        'Drinkable',
        'Cookies',
        'Sweets',
        'Canned',
        'Snacks',
        'Candy',
        'Fruits',
        'Meat',
        'Beverages',
        'Cereals & Grains',
        'Canned Goods',
        'Dairy & Eggs',
        'Fresh Produce'
        'Meat & Seafood',
        'Snacks & Confectionery',
        'Household & Cleaning',  
        'Frozen foods',
        // Add more categories here
    ];

    // Prepare insert statement
    $stmt = $db->prepare("INSERT INTO categories (category_name) VALUES (:category_name)");

    foreach ($categories as $category) {
        $stmt->execute([':category_name' => $category]);
    }

    echo "Categories inserted successfully.";

} catch (Exception $e) {
    echo "Error inserting categories: " . $e->getMessage();
}
