<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Branch;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$branchModel = new Branch();
$errors = [];
$success = '';

// Handle add new branch form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_branch'])) {
    $branch_name = trim($_POST['branch_name']);
    $address = trim($_POST['address']);
    $phone = trim($_POST['phone']);

    if (!$branch_name) {
        $errors[] = "Branch name is required.";
    }

    if (empty($errors)) {
        $created = $branchModel->createBranch($branch_name, $address, $phone);
        if ($created) {
            $success = "Branch added successfully.";
        } else {
            $errors[] = "Failed to add branch.";
        }
    }
}

// Handle delete branch (via GET)
if (isset($_GET['delete'])) {
    $delete_id = (int)$_GET['delete'];
    $branchModel->deleteBranch($delete_id);
    header("Location: branches.php");
    exit;
}

// Fetch all branches for listing
$branches = $branchModel->getAllBranches();

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Manage Branches</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <a href="dashboard.php" class="btn btn-secondary mb-3">← Back to Dashboard</a>
    <h1>Manage Branches</h1>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>
    <?php if ($errors): ?>
        <div class="alert alert-danger"><ul><?php foreach ($errors as $e): ?>
            <li><?= htmlspecialchars($e) ?></li>
        <?php endforeach; ?></ul>
        </div>
    <?php endif; ?>

    <h2>Add New Branch</h2>
    <form method="post" action="">
        <input type="hidden" name="add_branch" value="1" />
        <div class="mb-3">
            <label>Branch Name:</label>
            <input type="text" name="branch_name" class="form-control" required />
        </div>
        <div class="mb-3">
            <label>Address:</label>
            <textarea name="address" class="form-control"></textarea>
        </div>
        <div class="mb-3">
            <label>Phone:</label>
            <input type="text" name="phone" class="form-control" />
        </div>
        <button type="submit" class="btn btn-primary">Add Branch</button>
    </form>

    <hr />

    <h2>Existing Branches</h2>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>Branch ID</th><th>Name</th><th>Address</th><th>Phone</th><th>Created At</th><th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($branches as $branch): ?>
            <tr>
                <td><?= htmlspecialchars($branch['branch_id']) ?></td>
                <td><?= htmlspecialchars($branch['branch_name']) ?></td>
                <td><?= nl2br(htmlspecialchars($branch['address'])) ?></td>
                <td><?= htmlspecialchars($branch['phone']) ?></td>
                <td><?= htmlspecialchars($branch['created_at']) ?></td>
                <td>
                    <!-- Edit could link to edit_branch.php?id=... you can create similarly -->
                    <a href="edit_branch.php?id=<?= $branch['branch_id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                    <a href="branches.php?delete=<?= $branch['branch_id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this branch?')">Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
