<?php
// Database credentials - Replace with your config or secure load
$dbHost = 'localhost';
$dbUser = 'root';
$dbPass = '';
$dbName = 'your_database_name';

// Backup directory - make sure this directory exists and writable
$backupDir = __DIR__ . '/backups/';
if (!is_dir($backupDir)) {
    mkdir($backupDir, 0755, true);
}

$backupFile = $backupDir . "backup-{$dbName}-" . date('Ymd_His') . ".sql";

// Using mysqldump utility - preferred and reliable way
$command = "mysqldump --user={$dbUser} --password={$dbPass} --host={$dbHost} {$dbName} > {$backupFile}";

// Execute shell command
exec($command, $output, $resultCode);

if ($resultCode === 0) {
    echo "Backup successful! File created: {$backupFile}";
} else {
    echo "Backup failed. Please check server permissions and mysqldump availability.";
}
