<?php
// public/audit_logs.php

session_start();

require_once __DIR__ . '/../bootstrap.php';
require_once __DIR__ . '/../vendor/autoload.php';

use App\Models\AuditLog;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$user = $_SESSION['user'];
$auditLogModel = new AuditLog();

// Pagination setup
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$logsPerPage = 20;
$offset = ($page - 1) * $logsPerPage;

// Fetch audit logs with pagination
$logs = $auditLogModel->getRecentLogs($logsPerPage);
$totalLogs = 100; // Assuming default max logs fetched is 100 in your model
$totalPages = ceil($totalLogs / $logsPerPage);

function esc($str) {
    return htmlspecialchars($str, ENT_QUOTES | ENT_HTML5, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Audit Logs - Admin Panel</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
    <div class="container-fluid">
        <a class="navbar-brand" href="dashboard.php">Adwenpa POS Admin</a>
        <ul class="navbar-nav ms-auto">
            <li class="nav-item"><span class="navbar-text text-white">Hello, <?= esc($user['username']) ?></span></li>
            <li class="nav-item"><a href="logout.php" class="nav-link">Logout</a></li>
        </ul>
    </div>
</nav>

<main class="container mt-5 pt-3">
    <h1 class="mb-4">Audit Logs</h1>

    <?php if (empty($logs)) : ?>
        <div class="alert alert-info">No audit logs found.</div>
    <?php else : ?>
        <div class="table-responsive">
            <table class="table table-striped table-bordered align-middle">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Action</th>
                        <th>Details</th>
                        <th>Timestamp</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?= esc($log['username'] ?? 'System') ?></td>
                            <td><?= esc($log['action']) ?></td>
                            <td><pre><?= esc($log['details'] ?? '') ?></pre></td>
                            <td><?= esc($log['created_at'] ?? '') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination (if extended to support real total count) -->
    <?php endif; ?>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
