<?php
require_once __DIR__ . '/../../src/Controllers/UserController.php';

$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];
$uri_parts = explode('/', parse_url($uri, PHP_URL_PATH));
$id = $uri_parts[4] ?? null; // Assuming /api/user/{id}

$controller = new UserController();

switch ($method) {
    case 'GET':
        if ($id) {
            $controller->getUser($id);
        } else {
            $controller->listUsers();
        }
        break;

    case 'POST':
        $controller->createUser();
        break;

    case 'PUT':
    case 'PATCH':
        if ($id) {
            $controller->updateUser($id);
        } else {
            header("HTTP/1.1 400 Bad Request");
            echo json_encode(['error' => 'User ID is required for update']);
        }
        break;

    case 'DELETE':
        if ($id) {
            $controller->deleteUser($id);
        } else {
            header("HTTP/1.1 400 Bad Request");
            echo json_encode(['error' => 'User ID is required for delete']);
        }
        break;

    default:
        header("HTTP/1.1 405 Method Not Allowed");
        echo json_encode(['error' => 'Method Not Allowed']);
        break;
}
