<?php
require_once __DIR__ . '/../../src/Controllers/SaleController.php';

$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];
$uri_parts = explode('/', parse_url($uri, PHP_URL_PATH));
$id = $uri_parts[4] ?? null; // Assuming /api/sale/{id}

$controller = new SaleController();

switch ($method) {
    case 'GET':
        if ($id) {
            $controller->getSale($id);
        } else {
            $controller->listSales();
        }
        break;

    case 'POST':
        $controller->createSale();
        break;

    default:
        header("HTTP/1.1 405 Method Not Allowed");
        echo json_encode(['error' => 'Method Not Allowed']);
        break;
}
