<?php
// public/api/product.php

require_once __DIR__ . '/../../src/Controllers/ProductController.php';

// Get HTTP method and URI parts
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];

// Parse request path to get resource and id if present
$uri_parts = explode('/', parse_url($uri, PHP_URL_PATH));
$id = $uri_parts[4] ?? null;  // Assuming /api/product/{id}

$controller = new ProductController();

switch ($method) {
    case 'GET':
        if ($id) {
            $controller->getProduct($id);
        } else {
            $controller->listProducts();
        }
        break;

    case 'POST':
        $controller->createProduct();
        break;

    case 'PUT':
    case 'PATCH':
        if ($id) {
            $controller->updateProduct($id);
        } else {
            header("HTTP/1.1 400 Bad Request");
            echo json_encode(['error' => 'Product ID is required for update']);
        }
        break;

    case 'DELETE':
        if ($id) {
            $controller->deleteProduct($id);
        } else {
            header("HTTP/1.1 400 Bad Request");
            echo json_encode(['error' => 'Product ID is required for delete']);
        }
        break;

    default:
        header("HTTP/1.1 405 Method Not Allowed");
        echo json_encode(['error' => 'Method Not Allowed']);
        break;
}
