<?php
session_start();
require_once __DIR__ . '/../bootstrap.php';

use App\Models\Stock;
use App\Models\Inventory;
use App\Models\Branch;

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$stockModel = new Stock();
$inventoryModel = new Inventory();
$branchModel = new Branch();

$inventories = $inventoryModel->getAllItems();
$branches = $branchModel->getAllBranches();

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = (int)($_POST['product_id'] ?? 0);
    $quantity = (int)($_POST['quantity'] ?? 0);
    $branch_id = !empty($_POST['branch_id']) ? (int)$_POST['branch_id'] : null;

    if ($product_id <= 0) {
        $errors[] = "Please select a product.";
    }
    if ($quantity <= 0) {
        $errors[] = "Quantity must be greater than zero.";
    }

    if (empty($errors)) {
        $added = $stockModel->addStock($product_id, $quantity, $branch_id);
        if ($added) {
            $success = "Stock added successfully.";
        } else {
            $errors[] = "Failed to add stock.";
        }
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Add Stock - Super Market POS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <a href="stock.php" class="btn btn-secondary mb-3">← Back to Stock List</a>
    <h1>Add New Stock</h1>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <?php if ($errors): ?>
        <div class="alert alert-danger">
            <ul>
                <?php foreach ($errors as $e): ?><li><?= htmlspecialchars($e) ?></li><?php endforeach;?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="post" action="">
        <div class="mb-3">
            <label for="product_id" class="form-label">Product *</label>
            <select name="product_id" id="product_id" class="form-select" required>
                <option value="">Select Product</option>
                <?php foreach ($inventories as $item): ?>
                    <option value="<?= $item['inventory_id'] ?>" <?= (isset($product_id) && $product_id == $item['inventory_id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($item['product_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="quantity" class="form-label">Quantity *</label>
            <input type="number" name="quantity" id="quantity" class="form-control" required min="1" value="<?= isset($quantity) ? (int)$quantity : '' ?>">
        </div>

        <div class="mb-3">
            <label for="branch_id" class="form-label">Branch (optional)</label>
            <select name="branch_id" id="branch_id" class="form-select">
                <option value="">Select branch (optional)</option>
                <?php foreach ($branches as $branch): ?>
                <option value="<?= $branch['branch_id'] ?>" <?= (isset($branch_id) && $branch_id == $branch['branch_id']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($branch['branch_name']) ?>
                </option>
                <?php endforeach;?>
            </select>
        </div>

        <button type="submit" class="btn btn-success">Add Stock</button>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
