<?php
return [
    // Application environment: 'development' or 'production'
    'env' => 'development',

    // Database connection settings (under 'db' key)
    'db' => [
        'host' => 'localhost',
        'name' => 'adwenpasupermart',
        'user' => 'root',
        'pass' => '',
        'charset' => 'utf8mb4',  // use a valid charset like utf8mb4 or utf8
    ],

    // Base URL for your application
    'base_url' => 'http://localhost/adwenpasupermart/public/',

    // Session settings
    'session' => [
        'name' => 'adwenpa_session',
        'lifetime' => 7200,  // 2 hours in seconds
        'secure' => false,   // set to true if using HTTPS
        'httponly' => true,
        'samesite' => 'Lax',
    ],

    // Password hashing options for user authentication
    'password' => [
        'algo' => PASSWORD_DEFAULT,
        'options' => [
            'cost' => 12
        ],
    ],

    // Allowed payment methods (for validation)
    'payment_methods' => ['cash', 'card', 'insurance', 'mobile_money', 'other'],

    // Default timezone for date/time functions
    'timezone' => 'Africa/Accra',

    // Error reporting level
    'error_reporting' => E_ALL,

    // Logging settings
    'log' => [
        'path' => __DIR__ . '/../logs/app.log',
        'level' => 'debug',  // log levels: debug, info, warning, error
    ],

    // Additional configuration options can be added here as needed
];
