<?php
define('ROOT_DIR', __DIR__);
define('BASE_URL', 'http://localhost/adwenpasupermart/public/');

require_once ROOT_DIR . '/config/config.php';

spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = ROOT_DIR . '/src/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) return;

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) require $file;
});
